package com.adamsearle.utils {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	
	public class ScrollBar extends Sprite {
		private var _contentToScroll:DisplayObjectContainer;
		private var _sliderGripper:DisplayObject;
		private var _scrollbarComponentHeight:int;
		private var _contentMaskHeight:int;
		private var _track:Sprite;
		private var _slider:Sprite;
		private var _sliderArrows:Sprite;
		private var _sliderHeight:int;
		private var _pressed:Boolean = false;
		private const _scrollbarComponentWidth:int = 15;
		
		/**
		*	@author			Adam Searle
		*	@date			16/04/2008
		*	@description	creates a scrollbar based on a given content area and mask
		*	@version		v0.2
		*	
		*	@param		_contentToScroll	DisplayObjectContainer		the content to be scrolled - Sprite, MovieClip or Stage		
		*	@param		_contentMaskHeight	int							height of the mask that is masking the content
		*	@param		_scrollbarComponentHeight	int					total height to draw this scrollbar component
		*	
		*	@usage		var myScrollBar:ScrollBar = new ScrollBar(myContent, 400, 350, gripperBG)
		*	*/

		// Takes in a reference to the content to scroll, height of the mask masking the content, total height of scrollbar component to draw
		public function ScrollBar(_contentToScroll:DisplayObjectContainer, _contentMaskHeight:int, _scrollbarComponentHeight:int, _sliderGripper:DisplayObject) {
			this._contentToScroll = _contentToScroll;
			this._contentMaskHeight = _contentMaskHeight;
			this._scrollbarComponentHeight = _scrollbarComponentHeight;
			this._sliderGripper = _sliderGripper;
			
			// Initialise scrollbar
			initialise();
		}
		
		// Initialise sizes, draw _track, set up scrollbar and sensitivity
		public function initialise():void {
			
			// Draw the scrollbar background track
			_track = new Sprite();
			_track.graphics.beginFill(0xCDD0D3);
			_track.graphics.drawRect(0, 0, _scrollbarComponentWidth, _scrollbarComponentHeight);
			addChild(_track);
			
			// Determine the size of the _slider
			_sliderHeight = (_scrollbarComponentHeight / _contentToScroll.height) * _scrollbarComponentHeight;
			
			// Draw the _slider
			_slider = new Sprite();
			_slider.addChild(_sliderGripper);
			_sliderGripper.width = _scrollbarComponentWidth;
			_sliderGripper.height = _sliderHeight;
			//_slider.graphics.beginFill(0x00FF00);
			//_slider.graphics.drawRect(0, 0, _scrollbarComponentWidth, _sliderHeight);
			//_slider.graphics.endFill();
			
			_sliderArrows = new Sprite();
			_slider.addChild(_sliderArrows);
			_sliderArrows.graphics.lineStyle(1, 0xFFFFFF);
			_sliderArrows.graphics.moveTo(2, 12);
			_sliderArrows.graphics.lineTo(7, 3);
			_sliderArrows.graphics.lineTo(12, 12);
			_sliderArrows.graphics.moveTo(2, _sliderHeight-12);
			_sliderArrows.graphics.lineTo(7, _sliderHeight-3);
			_sliderArrows.graphics.lineTo(12, _sliderHeight-12);

			addChild(_slider);
			
			// When we are added to the stage, add the listeners
			_slider.addEventListener(Event.ADDED_TO_STAGE, addedListener);
		}
		
		private function addedListener(e:Event):void {
			// Remove the added to stage listener.. its cool.. we're on the stage now!
			_slider.removeEventListener(Event.ADDED_TO_STAGE, addedListener);
			
			// Add mouse down for _slider, mouse up for **stage** (as user can release over anything!)
			_slider.addEventListener(MouseEvent.MOUSE_DOWN, onDownListener);
			stage.addEventListener(MouseEvent.MOUSE_UP, onUpListener);
			
			// Use the button mode cursor
			_slider.buttonMode = true;
		}
		
		private function onDownListener(e:MouseEvent):void {
			_pressed = true;

			// Create a rectangle to define the bounds for dragging
			var rect:Rectangle = new Rectangle(0, 0, 0, _scrollbarComponentHeight - _sliderHeight);
			_slider.startDrag(false, rect);
			
			// Add a mouse move listener
			stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveListener);
		}
		
		private function onUpListener(e:MouseEvent):void {
			if (_pressed) {
				_pressed = false;
				_slider.stopDrag();
				
				// Remove the move listener
				stage.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoveListener);
			}
		}
		
		private function mouseMoveListener(e:MouseEvent):void {
			scrollContent();
		}
		
		private function scrollContent():void {
			// content scrolls from y=0 to some negative value..
			// percentage scrolled = scroller.y / total room for scrolling (_scrollbarComponentHeight - scroller.height)
			var percentage:Number = _slider.y / (_scrollbarComponentHeight - _slider.height);

			// content fully scrolled = -(content total height - mask height)			
			_contentToScroll.y = -(_contentToScroll.height - _contentMaskHeight) * percentage;
		}
	}
}